REM ***********************************************************************
REM THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
REM PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
REM EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
REM WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
REM AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
REM 
REM Copyright (c) 2005  Microsoft Corporation.  All rights reserved.
REM ***********************************************************************

@echo off

echo.
echo Utility to manage POP server
echo Valid operations:
echo 			Add mailbox 	-	a
echo 			Delete mailbox 	-	d
echo 			Change password - 	p
echo.

if "%5"=="" goto ALT_ENTER

REM Setup Environment Variables

set PopUsername=%1
set mailboxName=%2
set password=%3
set operation=%4
set domainName=%5
goto SKIP_ALT_ENTER

:ALT_ENTER

REM Ask for the Userinput
set /p PopUsername=Username:
set /p mailboxName=Mailbox name:
set /p password=Password:
set /p operation=Operation (Add, Delete, Changpass):
set /p domainName=Domain name:

:SKIP_ALT_ENTER

REM *** Add a new pop user ***
if "%operation%"=="a" (
			echo Adding POP User...
			winpop add %mailboxName%@%domainName% /createuser %password%
			echo Errorlevel: %errorlevel%
			echo Done.
			goto END
			)

REM *** Delete a pop user ***
if "%operation%"=="d" (
			echo Deleting POP User...
			winpop del %mailboxName%@%domainName% /deleteuser
			echo Errorlevel: %errorlevel%
			echo Done.
			goto END
			)


REM *** Change password ***
if "%operation%"=="p" (
			echo Changing password for mailbox %mailboxName%...
			winpop changepwd %mailboxName%@%domainName%
			echo Errorlevel: %errorlevel%
			echo Done.
			goto END
			)

:END

if "%5"=="" pause